/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.configuration;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.theawesomegem.fishingmadebetter.DefaultFishes;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.proxy.CommonProxy;
import net.theawesomegem.fishingmadebetter.util.TextUtils;
import org.apache.logging.log4j.Level;

public class CustomConfigurationHandler {
    public static Map<String, FishData> fishDataMap = new HashMap<String, FishData>();
    public static Map<String, ArrayList<Integer>> possibleBaitMap = new HashMap<String, ArrayList<Integer>>();
    private static File fishDataFolder = null;

    public static void preInit(File file) {
        File modFolder = new File(file, "fishingmadebetter");
        if (!(modFolder.exists() && modFolder.isDirectory() || modFolder.mkdir())) {
            CommonProxy.Logger.log(Level.FATAL, "Could not create the folder for configuration.");
        }
        if (!modFolder.exists()) {
            return;
        }
        fishDataFolder = new File(modFolder, "fishdata");
        if (!(fishDataFolder.exists() && fishDataFolder.isDirectory() || fishDataFolder.mkdir())) {
            CommonProxy.Logger.log(Level.FATAL, "Could not create the folder for fish data.");
        }
    }

    public static void postInit() {
        CustomConfigurationHandler.loadFishes();
    }

    public static boolean loadFishes() {
        if (fishDataFolder == null || !fishDataFolder.exists()) {
            CommonProxy.Logger.log(Level.FATAL, "Could not load fishes because the folder for the fish data does not exist.");
            return false;
        }
        File[] configFiles = fishDataFolder.listFiles();
        if (configFiles.length < 1) {
            CustomConfigurationHandler.initDefaultFishes(fishDataFolder);
            configFiles = fishDataFolder.listFiles();
            CommonProxy.Logger.log(Level.INFO, "Initializing default fishes since no file(s) were found in the fishdata folder.");
        }
        int fileCount = 0;
        fishDataMap.clear();
        for (File configFile : configFiles) {
            if (!configFile.exists() || !configFile.getName().endsWith(".json")) continue;
            CommonProxy.Logger.log(Level.INFO, "Loading: " + configFile.getName());
            CustomConfigurationHandler.loadConfig(configFile);
            ++fileCount;
        }
        CommonProxy.Logger.log(Level.INFO, String.format("Loaded %d file(s).", fileCount));
        CustomConfigurationHandler.initBaitMap();
        return true;
    }

    private static void initBaitMap() {
        possibleBaitMap.clear();
        for (Map.Entry<String, FishData> dataEntry : fishDataMap.entrySet()) {
            if (dataEntry.getValue().baitItemMap.isEmpty()) continue;
            for (Map.Entry<String, Integer[]> baitEntry : dataEntry.getValue().baitItemMap.entrySet()) {
                ArrayList<Object> metaArray = new ArrayList<Object>();
                if (possibleBaitMap.containsKey(baitEntry.getKey())) {
                    metaArray = possibleBaitMap.get(baitEntry.getKey());
                }
                metaArray.addAll(Arrays.asList((Object[])baitEntry.getValue()));
                possibleBaitMap.put(baitEntry.getKey(), metaArray);
            }
        }
    }

    private static void initDefaultFishes(File fishDataFolder) {
        Map<String, Map<String, FishData>> defaultFishDataMap = DefaultFishes.getDefaultFishMap();
        for (Map.Entry<String, Map<String, FishData>> defaultFishEntry : defaultFishDataMap.entrySet()) {
            boolean fileCreated;
            JsonObject fishDataJson = new JsonObject();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            for (FishData fishData : defaultFishEntry.getValue().values()) {
                JsonElement element = gson.toJsonTree((Object)fishData);
                fishDataJson.add(fishData.fishId, element);
            }
            String fishDataString = gson.toJson((JsonElement)fishDataJson);
            File file = new File(fishDataFolder, String.format("%s.json", defaultFishEntry.getKey()));
            try {
                fileCreated = file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (!fileCreated) {
                CommonProxy.Logger.log(Level.FATAL, "Could not create the fish data file.");
                continue;
            }
            try {
                boolean writeable = file.setWritable(true);
                if (!writeable) {
                    CommonProxy.Logger.log(Level.FATAL, "Cannot write/save the fish data file inside the fishdata folder. Insufficient permission.");
                    continue;
                }
                PrintWriter writer = new PrintWriter(file);
                writer.write(fishDataString);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadConfig(File configFile) {
        if (configFile == null || !configFile.exists()) {
            CommonProxy.Logger.log(Level.FATAL, "Could not load the fish data config file. File does not exist.");
            return;
        }
        try {
            boolean readable = configFile.setReadable(true);
            if (!readable) {
                CommonProxy.Logger.log(Level.FATAL, String.format("Cannot read file %s. No permission to read the file.", configFile.getName()));
                return;
            }
            String fishDataString = Files.toString((File)configFile, (Charset)Charset.defaultCharset());
            CustomConfigurationHandler.loadFishData(new JsonParser().parse(fishDataString));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadFishData(JsonElement jsonElement) {
        JsonObject fishDataJson = jsonElement.getAsJsonObject();
        Gson gson = new Gson();
        HashMap tmpFishMap = new HashMap();
        for (Map.Entry entry : fishDataJson.entrySet()) {
            JsonElement fishDataElement = (JsonElement)entry.getValue();
            FishData fishData = (FishData)gson.fromJson(fishDataElement, FishData.class);
            if (TextUtils.isEmpty(fishData.itemId)) continue;
            Item item = Item.func_111206_d((String)fishData.itemId);
            if (item == null) {
                CommonProxy.Logger.log(Level.WARN, "Tried loading fish data entry with invalid item: " + fishData.itemId + " , skipping entry.");
                continue;
            }
            tmpFishMap.put(entry.getKey(), fishData);
        }
        CommonProxy.Logger.log(Level.INFO, "=========== Loaded Fishes ============");
        for (Map.Entry entry : tmpFishMap.entrySet()) {
            fishDataMap.put((String)entry.getKey(), (FishData)entry.getValue());
            CommonProxy.Logger.log(Level.INFO, ((FishData)entry.getValue()).fishId);
        }
        CommonProxy.Logger.log(Level.INFO, "======================================");
    }

    public static Collection<FishData> getAllFishData() {
        return fishDataMap.values();
    }
}

